 ; Ŀ
 ;   Cyl: vertical/horizontal 2D Cylinder maker                            
 ;   Copyright 1994, 1998, 2005 by Rocket Software Ltd.                    
 ;   Rocket: better than having an anvil on your desk.                     
 ; 

 ; Ŀ
 ;   IV - subroutine - choose horizontal or vertical with the digitizer.   
 ; 
 (DEFUN IV (/ ang orient)
  (setq ang (getangle (cadr (grread t)) "\nAxis direction: "))
  (if (> ang pi) (setq ang (- ang pi)))
  (if (and (> ang (/ pi 4)) (< ang (* pi 0.75)))
      (setq orient "Vertical")
      (setq orient "Horizontal"))
 orient)
 ; Ŀ
 ;   IV end.                                                               
 ; 

 ; Ŀ
 ;   Cyl.                                                                  
 ; 
 (defun c:cyl ( / osmo *error* aa cc bb dd numm incran theta hypot sidopp)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (if osmo (setvar "osmode" osmo))
   (command ".undo" "end")
  (princ))
 ; Ŀ
 ;   Get the corner points, draw the outline.                              
 ; 
  (setq aa (getpoint "First corner:"))
  (setq cc (getcorner aa "Other corner:\n"))
  (setq bb (cons (car cc) (cdr aa)))
  (setq dd (cons (car aa) (cdr cc)))
  (setvar "osmode" 0)
  (command ".pline" aa bb cc dd aa "")
 ; Ŀ
 ;   Ask for a number of spaces.                                           
 ; 
  (if (/= (type num) 'INT) (setq num 16))
  (setq numm (getint (strcat "Number of spaces <" (itoa num) ">: ")))
  (if numm (setq num numm))
  (setq incran (/ pi num))
  (if (= "Horizontal" (iv))
      (progn  
           (setq theta (* pi 1.5))
           (setq hypot (/ (distance aa dd) 2))
           (setq aa (polar aa (* pi 1.5) hypot))
           (setq bb (polar bb (* pi 1.5) hypot))
           (repeat num
                  (setq sidopp (* hypot (sin theta)))
                  (setq cc (polar aa (* pi 1.5) sidopp))
                  (setq dd (polar bb (* pi 1.5) sidopp))
                  (command "line" cc dd "")
                  (setq theta (+ theta incran))))
      (progn  
           (setq theta (* pi 1.5))           ; 90 out to give + and - offsets
           (setq hypot (/ (distance aa bb) 2))
           (setq aa (polar aa 0 hypot))
           (setq dd (polar dd 0 hypot))
           (repeat num
                  (setq sidopp (* hypot (sin theta)))
                  (setq cc (polar aa 0 sidopp))
                  (setq bb (polar dd 0 sidopp))
                  (command "line" cc bb "")
                  (setq theta (+ theta incran)))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (setvar "osmode" osmo)
  (command ".undo" "end")
 (princ))